<?php
/**
 * Testscript 
 *
 * Dieses Script bietet die einzelnen Tests zum Start an
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package PaketManager
 */

/**
 * Fehlerbehandlung setzen
 */
ini_set('display_errors', TRUE);
error_reporting(E_ALL);


/**
 * Zeitzone setzen (seit PHP 6 nötig)
 */
date_default_timezone_set('Europe/Berlin');

/**
 * Die Namespace Autoloader klasse laden
 */
require_once "./Phpnsautoloader.php";

/**
 * Den Namespace Autoloader registrieren
 */
Phpnsautoloader::register();

// Ab hier stehen alle Klassen automatisch zur verfügung

/**
 * Liest das Verzeichnis rekursiv aus und
 * liefert alle TestScripte in einem Array
 * @param string $dir der zu durchsuchende Ordner
 * @return array Array mit Dateinamen
 */
function get_all_tests($dir)
{
  $result = glob($dir.'/test_*.php');
  foreach(glob($dir.'/*',GLOB_ONLYDIR) as $newdir)
    $result = array_merge($result,get_all_tests($newdir));
  return $result;
}

/**
 * Array mit den Testscripten zusammensuchen
 */
$tests = get_all_tests(dirname(__FILE__));

if(isset($_GET['test']) && isset($tests[$_GET['test']]))
{
/**
 * Laden des ausgewählten Testscriptes
 */
    include $tests[$_GET['test']];
    exit;
}

/**
 * Ausgabe der Links für alle gefundenen Testscripte
 */
foreach($tests as $index => $testmodul)
{
  $testmodul = realpath($testmodul);
  $docroot = realpath($_SERVER['DOCUMENT_ROOT']);
  echo  sprintf('%06d ',$index)."";
  echo  "<a href='$_SERVER[SCRIPT_NAME]?test=$index'>";
  echo  str_replace($docroot,'',$testmodul);
  echo  "</a>";
  echo  "<br>";
}

?>
