<?php
/**
 * PhpNsAutoloader
 *
 * Dieser Autoloader arbeitet mit den neuen Namespaces
 * welche mit PHP 5.3 eingeführt wurden Und auch mit den
 * dunnemals von Pear und Zend eingeführten
 *
 *Beispiel:
 *<code>
 *
 *<?php
 * // Den Namspace Autoloader laden
 * require_once "./Phpnsautoloader.php";
 *
 * // und Bei dem SPL Autoloader registrieren
 * PhpNsAutoloader::register();
 *
 *</code>
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package PaketManager
 */

/**
 * Der Autolader
 *
 * @package PaketManager
 */
class Phpnsautoloader
{

/**
 * Der Namspace Autolader
 *
 * Der übergebene Klassenname wird gemäß den Namespace Regeln
 * aufgelöst und es wird versucht die betreffende Klasse zu laden
 * @link http://www.php.net/manual/de/language.namespaces.php PHP_Namespace_Benennungsschema
 * @link http://pear.php.net/manual/de/pear2cs.rules.php PEAR2_Namespace_Benennungsschema
 * @param string $name Name der zu ladenen Klasse
 * @return void Keine Rückgabe
 */
  public static function NS_autoload($name)
  {
   // $name= strtolower($name);
    $dirname  = dirname(__FILE__);
    $fileName = str_replace('\\',DIRECTORY_SEPARATOR,$name).'.php';
    $file     = $dirname.DIRECTORY_SEPARATOR.$fileName;
    if (is_readable($file)) require_once $file;
  }

/**
 * Der Zend/PEAR Autolader
 *
 * Der übergebene Klassenname wird gemäß den Namensvergaberegeln
 * von Zend und PEAR aufgelöst und es wird versucht die betreffende
 * Klasse zu laden
 * @link http://framework.zend.com/manual/de/coding-standard.naming-conventions.html Zend_Benennungsschema
 * @link http://pear.php.net/manual/de/standards.naming.php PEAR1_Benennungsschema
 * @param string $name Name der zu ladenen Klasse
 * @return void Keine Rückgabe
 */
  public static function ZP_autoload($name)
  {
  //  $name= strtolower($name);
    $dirname  = dirname(__FILE__);
    $fileName = str_replace('_',DIRECTORY_SEPARATOR,$name).'.php';
    $file     = $dirname.DIRECTORY_SEPARATOR.$fileName;
    if (is_readable($file)) require_once $file;
  }

/**
 * Autolader Registrierung
 *
 * Die statische Methode des Namspace Autoloaders wird bei dem
 * SPL Autoloader registiert
 * @return void Keine Rückgabe
 */
  public static function register()
  {
    spl_autoload_register(array(__class__,'NS_autoload'));
    spl_autoload_register(array(__class__,'ZP_autoload'));
  }
}






?>
