<?php
/**
 * Test des Datenbank Wrappers
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage DB
 */


namespace Combie\Db;

echo "<br>Test sqlite<br>";
try
{
  $db = Db::factory('sqlite://localhost/test.sq3');
  try
  {
    @$db->query('CREATE TABLE irgendwas (feld varchar(255))');
    $db->query("INSERT INTO irgendwas VALUES ('ein Wert')");
    $db->query("INSERT INTO irgendwas VALUES ('und noch einer')");
  }
  catch (DbException $e)
  {
    // Tabelle gibts schon, ist aber egal..
  }
  $res = $db->query('SELECT * FROM irgendwas');
  foreach($res as $key => $row)
  {
    echo 'Datensatz '.$key.': ';
    print_r($row);
    echo '<br> ';
  }
}
catch (DbException $e)
{
  echo 'DB Ausnahme gefangen: ',  $e->getMessage(), "<br>";
}
catch (Exception $e)
{
  echo 'Allgemeine Ausnahme gefangen: ',  $e->getMessage(), "<br>";
}


// --------------------------------


echo "<hr> ";

echo "<br>Test mysql über angegebenen Port<br>";
try
{
  $db = Db::factory('mysql://test:test@localhost:3036/test');
  $res = $db->query('SELECT * FROM irgendwas');
  foreach($res as $row)
  {
    echo 'Daten: ';
    print_r($row);
    echo '<br> ';
  }
}
catch (Exception $e)
{
  echo 'Ausnahme gefangen: ',  $e->getMessage(), "<br>";
}


// --------------------------------


echo "<hr> ";

echo "<br>Test mysql über Standardverbindung<br>";
try
{
  $db = Db::factory('mysql://test:test@localhost/test');
  $res = $db->query('SELECT * FROM irgendwas');
  foreach($res as $row)
  {
    echo 'Daten: ';
    print_r($row);
    echo '<br> ';
  }
}
catch (Exception $e)
{
  echo 'Ausnahme gefangen: ',  $e->getMessage(), "<br>";
}
echo "<hr> ";

?>
