<?php
/**
 * Timer
 *
 * Eine Stoppuhr für performance Messungen
 *
 * Beispiel:
 *<code>
 *<?php
 * use Combie::Time;
 *
 * echo "<br>Test des Timers<br>";
 *
 * // ein Timer Objekt erzeugen
 * $timer = new Time\Timer;
 *
 * $timer->start(); // starten
 *
 * $test = glob('../*'); //  der zu messende Code
 *
 * $timer->stop(); // stoppen
 *
 * // Ausgabe
 * echo '<br>Abgelaufene Zeit:<br>';
 * echo $timer->usedtime().'<br>';
 *
 *</code>
 *
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Time
 */


namespace Combie\Time;


/**
 * Timer
 *
 * Ein Modul für Zeitmessungen
 * @example packages/Combie/tests/time/test_timer.php
 * @package Combie
 * @subpackage Time
 */
class Timer
{

/**#@+
 * interne Variablen
 * @var float Zeit
 */
  private static $wasserkopf  = 0;
  private $start              = 0;
  private $stop               = 0;
/**#@-*/

/**
 * Konstruktor
 *
 * konstruiert das Objekt und berechtet, wenn noch nicht geschehen,
 * die Wasserkopfkonstante um Messwertverfäschungen zu verhindern
 * @return void Keine Rückgabe
 */
  public function __construct()
  {
   if(0 === self::$wasserkopf)
       $this->scale();
  }

/**
 * Berechnung der Wasserkopf Konstanten
 *
 * Berechtet die Wasserkopf Konstante und speichet sie
 * in der statischen Variablen $wasserkopf
 * @return void Keine Rückgabe
 */
  private function scale()
  {
    $times = array();
    for ($i=0;$i<20;$i++)
    {
      $this->start();
      $times[] = $this->stop();
    }
    sort($times);
    for ($j=0;$j<4;$j++) array_pop($times);
    self::$wasserkopf = array_sum($times) / count($times);
  }

/**
 * Benutzte Zeit
 *
 * Berechtet die Abgelaugfene Zeit und gibt sie zurück
 * @return float Abgelaufenen Zeit
 */
  public function usedtime()
  {
    if($this->stop === 0)
    {
      return microtime(TRUE) - $this->start - self::$wasserkopf;
    }else
    {
      return $this->stop - $this->start - self::$wasserkopf;
    }
  }

/**
 * Start Timer
 *
 * Startet den Messvorgang und gibt die Startzeit zurück
 * @return float Start Zeit
 */
  public function start()
  {
    $this->stop = 0;
    $this->start = microtime(TRUE);
    return $this->start;
  }

/**
 * Stop Timer
 *
 * Stoppt den Messvorgang und gibt die verbrauchte Zeit zurück
 * @return float Start Zeit
 */
  public function stop()
  {
    $this->stop = microtime(TRUE);
    return $this->usedtime();
  }
  
/**
 * Mehrfache Ausführung
 *
 * Führt eine Funktion mehrfach zur Zeitmessung aus und gibt den Mittelwert
 * der pro durchlauf verbrauchten Zeit zurück
 * @return float Mittelwert der verbrauchten Zeit
 */
  public function n_times($anzahl,$function/* weitere Parameter */)
  {
    $params = func_get_args();
    array_pop($params);
    array_pop($params);
    $times = array();
    for ($i=0;$i<$anzahl;$i++)
    {
      $this->start;
      call_user_func_array($function,$params);
      $times[] = $this->stop();
    }
    return array_sum($times) / count($times);
  }

/**
 * Wasserkopf
 *
 * Gibt die Zeit zurück, welche von der Klasse intern für jede Messung
 * verbraucht wird
 * @return float Wasserkopf
 */
  public function lag()
  {
    return self::$wasserkopf;
  }
}
 
?>
