<?php
/**
 * Abstract Singleton
 *
 * Die Mutter aller Singleton Klassen
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Struktur
 */

namespace Combie\Struktur;

/**
 * Abstract Singleton
 *
 * Die Mutter aller Singleton Klassen
 * @package Combie
 * @subpackage Struktur
 */
abstract class Singleton
{

/**
 * Alle Singletons
 *
 * @var array of Singleton
 */
    private static $instances = array();

/**
 * Alle Singletons
 *
 * @return Singleton Das angeforderte Objekt
 */
    final public static function getInstance()
    {
      $class = get_called_class();
      if(empty(self::$instances[$class]))
        self::$instances[$class] = new $class;
      return self::$instances[$class];
    }

/**
 * Konstruktor
 *
 * Sichtbarkeit einschränken
 * @return Singleton Das angeforderte Objekt
 */
    protected function __construct(){}
    
/**
 * clone
 *
 * Sichtbarkeit einschränken und festlegen
 * diese Objekt darf niemals geclont werden
 *
 *
 * @return void Keine Rückgabe
 */
    final private function __clone(){}
}
?>
