<?php
/**
 * Pager Blätterfunktion
 *
 * 
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Struktur
 */

namespace Combie\Struktur;

/**
 * Pager Blätterfunktion
 *
 *
 * @package Combie
 * @subpackage Struktur
 */

class Pager
{
/**
 *
 * @var integer Elemente pro Seite
 */
  private $perpage  = 1; 
  
/**
 *
 * @var integer Insgesamt vorhandene Elemente
 */
  private $anzahl   = 0;

/**
 *
 * @param integer Insgesamt vorhandene Elemente
 * @param integer Elemente pro Seite
 * @return void Keine Rückgabe
 */
  public function __construct($anzahl,$perpage=1)
  {
    if($anzahl  < 0) throw new Exception('Negative Anzahl!');
    if($perpage < 1) throw new Exception('Min 1 Element per Page!');
    $this->perpage  = (int)$perpage; // integer erzwingen
    $this->anzahl   = (int)$anzahl;  // integer erzwingen
  }

/**
 * Anzahl Seiten
 * @return integer Anzahl Seiten
 */
  public function pages() // anzahl Seiten
  {
    return (int)ceil($this->anzahl/$this->perpage);
  }

/**
 * Seite
 *
 *
 * @return array Ein Array mit offset und Anzahl pro Seite
 */
  public function page($index) // gibt den ausgewählten Ausschnitt
  {
    $index  = (int)$index; // integer erzwingen
    if($index < 1) throw new Exception('Index to low!');
    $index--; // normalisieren
    $offset = $this->perpage * $index;
    if($offset >= $this->anzahl)
        throw new Exception('Index out of Range!');
    return array('offset'=>$offset,'count'=>$this->perpage);
  }
}

?>
