<?php

namespace Combie\Struktur ;

class DIContainer
{
  protected $values = array();

  public function __construct($file)
  {
    include $file;
  }

  public function __set($id, $value)
  {
    $this->values[$id] = $value;
  }
  
  public function __get($id)
  {
    if (!isset($this->values[$id]))
      throw new InvalidArgumentException("Value '$id' is not defined.");
    $val = $this->values[$id];
    return $this->is_lambda($val)?$val($this):$val;
  }

  public function __call($id,Array $params=array())
  {
    $val = $this->__get($id);
    if (!is_callable($val))
      throw new InvalidArgumentException("Value '$id' is not callable.");
    return call_user_func_array($val,$params);
  }
  
  public function __isset($id)
  {
      return isset($this->values[$id]);
  }

  public function __unset($id)
  {
      unset($this->values[$id]);
  }

  protected function asSingleton(\Closure $factory)
  {
    return  function (DIContainer $di) use ($factory)
            {
              static $object = null;
              if (is_null($object)) $object = $factory($di);
              return $object;
            };
  }
  
  protected function asLambda(\Closure $lambda)
  {
    return  function () use ($lambda)
            {
              return $lambda;
            };
  }
  
  protected function is_lambda($var)
  {
    return is_object($var) && 'Closure' === get_class($var);
  }
}
?>
