<?php
/**
 * Array Pager - Blätterfunktion
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Struktur
 */

namespace Combie\Struktur;

/**
 * Array Pager - Blätterfunktion
 *
 * Blättern in Array Strukturen
 * @package Combie
 * @subpackage Struktur
 */
class ArrayPager extends Pager
{

/**
 *
 * @var array Alle Elemente
 */
  private $array = array(); // alle Elemente


/**
 *
 * @param array In dem geblättert werden soll
 * @return void Keine Rückgabe
 */
  public function __construct(Array &$array, $perpage=1)
  {
    parent::__construct(count($array),$perpage);
    $this->array = array_values($array); // Index normalisieren
  }


/**
 * Page
 *
 * Gibt einen Arrayausschnitt zurück
 * @param integer Seitennummer
 * @return array Arrayausschnitt
 */
  public function page($index) // gibt den ausgewählten Ausschnitt
  {
    $bereich = parent::page($index); // auschnitt berechnen
    return array_slice($this->array,$bereich['offset'],$bereich['count']);
  }
}

?>
