<?php
/**
 * MagicQuotes
 *
 * Entfernt die MagicQuotes aus den Superglobalen Arrays
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Server
 */


namespace Combie\Server;

/**
 * MagicQuotes
 *
 * Entfernt die MagicQuotes aus den Superglobalen Arrays
 *
 * @example packages/Combie/tests/server/test_magicquotes.php
 * @package Combie
 * @subpackage Server
 */
final class MagicQuotes
{
/**
 * interne Variable OneShot
 * Markierung, welche den Durchgang nur einmal erlaubt
 *
 * @var boolean Ein Mal
*/
  private static $oneshot = FALSE;



/**
 * Strip
 *
 * Macht die MagicQuotes Einstellung rückgängig
 *
 * @param void kein Parameter
 * @return void keine Rückgabe
 */
  public static function strip()
  {
    if(self::$oneshot) throw new \Exception('Call this only once!');
    self::$oneshot = TRUE;
    if(function_exists('get_magic_quotes_gpc')&& get_magic_quotes_gpc())
    {



      $callBack = create_function('&$item','$item = stripslashes($item);');


      
      $superglobals = array('_GET','_POST','_COOKIE','_REQUEST','_FILES');
      foreach($superglobals as $superglobal)
        if(is_array($GLOBALS[$superglobal]))
          array_walk_recursive($GLOBALS[$superglobal],$callBack);
    }
    if(function_exists('set_magic_quotes_runtime'))
        set_magic_quotes_runtime(FALSE);
  }
}
 
?>
