<?php
/**
 * Math Functions
 *
 * Mathematische Funktionssammlung
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Math
 */


namespace Combie\Math;

/**
 * Functions
 *
 * Mathematische Funktionssammlung
 *
 * Mathematische Funktionssammlung
 * @example packages/Combie/tests/math/test_functions.php
 * @package Combie
 * @subpackage Math
 */
class Functions
{

/**
 * Gerade
 *
 * Gibt True zurück, wenn die Zahl restlos durch 2 teilbar ist
 * @param integer Zahl, welche getestet werden soll
 * @return bool True wenn gerade, sonst FALSE
 */
  public static function even($zahl)
  {
    if(!is_int($zahl)) throw  new InvalidArgumentException('Param ist not a Integer');
    return !($zahl & 1);
  }

/**
 * Ungerade
 *
 * Gibt True zurück, wenn die Zahl nicht restlos durch 2 teilbar ist
 * @param integer Zahl, welche getestet werden soll
 * @return bool True wenn ungerade, sonst FALSE
 */
  public static function uneven($zahl)
  {
    if(!is_int($zahl)) throw  new InvalidArgumentException('Param ist not a Integer');
    return (bool)($zahl & 1);
  }

}
 
?>
