<?php
/**
 * Db Driver Interface
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage DB
 */

namespace Combie ;

/**
 * Db Driver Interface
 *
 * Geimeinsame Schnittstelle aller Datembank Treiber
 * @package Combie
 * @subpackage DB
 */
interface Idb
{
/**
 *
 * @param string DNS der gewünschten Verbindung
 */
  public function __construct($dburl);
  
/**
 *
 * @param string SQL
 * @return Result Rückgabe des Result Objektes
 */
  public function query($query);
  
/**
 *
 * @param resource Datenbank Ressource
 * @return array Rückgabe eines assoziativen Arrays (1 Datensatz)
 */
  public function fetch($res);
  
/**
 *
 * @param resource Datenbank Ressource
 * @return integer Anzahl Datensätze
 */
  public function numrows($res);
  
/**
 *
 * @param resource Datenbank Ressource
 * @return integer Autoincrement des letzten eingefügten Datensatzes
 */
  public function insertid($res);
  
/**
 *
 * @param resource Datenbank Ressource
 * @param integer  Nummer des Datensatzes
 * @return void Keine Rückgabe
 */
  public function seek($res,$index);
  
/**
 *
 * @param resource Datenbank Ressource
 * @return void Keine Rückgabe
 */
  public function free($res);
}


?>
