<?php
/**
 *
 *
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage Html
 */


 
 namespace Combie\Html;


/**
 * Linkbuilder
 *
 * @package Combie
 * @subpackage Html
 */
class Link
{
  private $parts = NULL;
  private $seperator = '&';
  
  public function __construct($url,$seperator='&')
  {
    $this->seperator = $seperator;
    $this->parts = parse_url($url);
    if(!empty($this->parts['query']))
    {
      $params = explode($seperator,$this->parts['query']);
      $this->parts['query'] = array();
      foreach($params as $param)
      {
        list($key,$value)= explode('=',$param);
        $this->parts['query'][urldecode($key)] = urldecode($value);
      }
    }
  }
  
  public function setParam($key,$value)
  {
    $this->parts['query'][$key] = $value;
  }
  
  public function getParam($key)
  {
    return $this->parts['query'][$key];
  }
  
  public function delParam($key)
  {
    unset($this->parts['query'][$key]);
  }
  
  public function __get($part)
  {
    if(!isset($this->parts[$part])) return FALSE;
    return $this->parts[$part];
  }
  
  public function __set($part,$value)
  {
    $this->parts[$part] = $value;
  }
  
  public function getUrl()
  {
    $url  = $this->parts['scheme'];
    $url .= '//:';
    $auth = isset($this->parts['user'])?$this->parts['user']:'';
    $auth .= ':';
    $auth .= isset($this->parts['pass'])?$this->parts['pass']:'';
    $auth .= '@';
    if(strlen($auth)>2)
      $url .= $auth;
    if(!empty($this->parts['host']))
      $url .= $this->parts['host'];
    if(!empty($this->parts['port']))
      $url .= ':'.$this->parts['port'];
    if(!empty($this->parts['path']))
      $url .= $this->parts['path'];
    $query = '';
    $teile=array();
    foreach($this->parts['query'] as $key => $value)
    {
      $teile[]= urlencode($key).'='.urlencode($value);
    }
    $query = implode($this->seperator,$teile);
    if(!empty($query))
      $url .= '?'.$query;
    if(!empty($this->parts['fragment']))
      $url .= '#'.$this->parts['fragment'];
    return $url;
  }
}
/*  public function __toSring()
  {
    return getUrl();
  }


$url      = 'http://www.schoeneseite.com/index.php?var1=1234&var2=98';

$urlobj = new url($url);
$urlobj->user = 'willi';
$urlobj->pass = 'geheim';
$urlobj->fragment = 'anker';
$urlobj->seperator = '&amp;';
$urlobj->setParam('affe','2 3+öär');


echo '<pre>'.var_export($urlobj,TRUE).'</pre>';
echo '<pre>'.var_export($urlobj->query,TRUE).'</pre>';
echo htmlentities($urlobj->getUrl());
*/
 
?>
