<?php
/**
 * Abstaktion der DB Ergebnismenge
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage DB
 */
//http://www.sitepoint.com/article/php5-standard-library/1
namespace Combie\Db ;

/**
 * Abstaktion der DB Ergebnismenge
 *
 * @package Combie
 * @subpackage DB
 */
class Result implements \Iterator, \Countable
{
  private $driver             = NULL;
  private $ergebnis_resource  = NULL;
  private $count  = 0;
  private $pos    = 0;
  private $row    = FALSE;

  public function __construct(\Combie\Idb $driver, $ergebnis_resource)
  {
    if(!is_resource($ergebnis_resource))
     throw DbException('Parameter ist keine Resource');
   $this->driver            = $driver;
   $this->ergebnis_resource = $ergebnis_resource;
   $this->count = $driver->numrows($ergebnis_resource);
  }
  
  public function free()
  {
    if(is_resource($this->driver))
      $this->driver->free($this->ergebnis_resource);
    $this->driver = NULL;
    $this->count  = 0;
    $this->pos    = 0;
    $this->row    = FALSE;
  }
  public function __destruct()
  {
    $this->free();
  }

  public function count()
  {
    return $this->count;
  }
  public function numrows()
  {
    return $this->count;
  }
  public function insertid()
  {
    return $this->driver->insertid($this->ergebnis_resource);
  }

   /**
   * Rewind the Iterator to the first element.
   * Similar to the reset() function for arrays in PHP
   * @return void
   */
   public function rewind()
  {
    $this->driver->seek($this->ergebnis_resource,0);
    $this->row=$this->driver->fetch($this->ergebnis_resource);
    $this->pos    = 0;
  }

   /**
   * Return the current element.
   * Similar to the current() function for arrays in PHP
   * @return mixed current element from the collection
   */
   public function current()
  {
    if(FALSE === $this->row)
    {
     $this->driver->seek($this->ergebnis_resource,$this->pos);
     $this->row=$this->driver->fetch($this->ergebnis_resource);
    }
    return $this->row;
  }

   /**
   * Return the identifying key of the current element.
   * Similar to the key() function for arrays in PHP
   * @return mixed either an integer or a string
   */
   public function key()
  {
    return $this->pos;
  }

   /**
   * Move forward to next element.
   * Similar to the next() function for arrays in PHP
   * @return void
   */
   public function next()
   {
      $this->pos++;
      $this->row=$this->driver->fetch($this->ergebnis_resource);
   }

   /**
   * Check if there is a current element after calls to rewind() or next().
   * Used to check if we've iterated to the end of the collection
   * @return boolean FALSE if there's nothing more to iterate over
   */
   public function valid()
   {
      return (bool) $this->row;
   }

}

?>
