<?php
/**
 * Sqlite Driver
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage DB
 */


namespace Combie\Db\Driver ;

use Combie\Db;

/**
 * Sqlite Driver
 *
 * @package Combie
 * @subpackage DB
 */
class Sqlite implements \Combie\Idb
{
/**
 * SQLite Conncet Handle
 *
 */
  private $handle = FALSE;
  
  public function __construct($dburl)
  {
    if(!function_exists('sqlite_open')) Throw new Db\DbException('sqlite Erweiterung nicht geladen');
    $path = parse_url($dburl);
    $this->handle = sqlite_open(trim($path['path'],"/"));
    if(FALSE === $this->handle) Throw new Db\DbException('Can not open: '.$dburl);
  }
  public function __destruct()
  {
    if(is_resource($this->handle))
        sqlite_close($this->handle);
  }


  public function query($query)
  {
    $res = sqlite_query($query,$this->handle);
    if(sqlite_last_error($this->handle))
      Throw new Db\DbException(sqlite_error_string(sqlite_last_error($this->handle)));
    return new Db\Result($this,$res);
  }
  
  public function free($res)
  {
    // do nothing
  }
  
  public function fetch($res)
  {
      return sqlite_fetch_array($res,SQLITE_ASSOC);
  }

  public function numrows($res)
  {
    return sqlite_num_rows($res);
  }

  public function insertid($res)
  {
    return sqlite_last_insert_rowid($res);
  }

  public function seek($res,$index)
  {
    return sqlite_seek ($res,$index);
  }

}

?>
