<?php
/**
 * Db Factory
 *
 * Erzeugt die konkret benötigte DB Klasse
 *
 * @filesource
 * @author Combie <uli@combie.de>
 * @version $Id$
 * @package Combie
 * @subpackage DB
 */

namespace Combie ;

/**
 * Db Factory
 *
 * Erzeugt die konkret benötigte DB Klasse
 *
 *
 * @package Combie
 * @subpackage DB
 */
class Db
{
/**
 * Factory
 *
 * Erzeugt die konkret benötigte DB Klasse
 *
 *
 * @param string Datenbank DSN oder URL
 * @return Idb das Konkrete Datenbank Objekt
 */
  static public function factory($dburl)
  {
    $path   = parse_url($dburl);

    // Scheme normalisieren
    $scheme = $path['scheme'];
    $scheme = strtolower($scheme);
    $scheme = ucfirst($scheme);
    $type   = 'Combie\\Db\\Driver\\'.$scheme;
    return new $type($dburl);
  }
}

?>
